#version 330
#extension GL_EXT_gpu_shader4 : enable
//Cours 2 3D - IUT2Mod01.fsh  by  vangriea
//https://www.shadertoy.com/view/NdSfzd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Antonio VAN GRIEKEN FUGUET
//LP Applications Web

#define R iResolution.xy
#define DIST_MIN 0.5 // minimum distance to objects
#define DIST_MAX 30.0 // maximum distance to objects
#define RAY_MARCH_STEPS 100
#define RAY_MARCH_PRECI 0.001
#define PI 3.14159265359
#define mouseUp      ( iMouse.z < 0. )                  // mouse up even:   mouse button released (well, not just that frame). cf https://www.shadertoy.com/view/3dcBRS
#define mouseDown    ( iMouse.z > 0. && iMouse.w > 0. ) // mouse down even: mouse button just clicked
#define mouseClicked ( iMouse.w < 0. )                  // mouse clicked:   mouse button currently clicked
#define fond vec3(vec2(iMouse.xy/iResolution.xy),1.0)
// ray structure
struct Ray {
    vec3 o; // origin
    vec3 d; // direction
};

struct Surface {
    float t; // surface distance
    vec3 c; // surface color
};

float sdSphere( vec3 p, float s ) {
  return length(p)-s;
}

Surface minSurf(Surface s1, Surface s2){
    if(s1.t < s2.t){
        return s1;
    }else{
        return s2;
    }
}

Surface scene(in vec3 p) {
    vec3 t = p*2.;
    float v1 = (cos(t.x)*cos(t.y)*cos(t.z)/9.)*sin(iTime*2.);
    float v2 = ((sin(t.x)+sin(t.y))/5.)*sin(iTime*2.);
    float v5 = ((sin(t.x)+cos(t.y))/4.5)*sin(iTime*5.);
    float v3 = ((sin(t.x)+sin(t.y))/9.)*sin(iTime*4.);
    float v4 = ((sin(t.x)+sin(t.y))/9.)*sin(iTime*9.);
    
    float d1 = sdSphere(p+(sin(iTime*1.3)*2.)+vec3(3.,0.5+cos(iTime)*2.,-4.),1.1)+v1;
    float d2 = sdSphere(p+(cos(iTime*1.2)*2.)+vec3(1.,5.,-2.),1.2)+v4;
    float d3 = sdSphere(p+(sin(iTime)*4.)+vec3(5.,6.,6.),0.5)+v3;
    float d4 = sdSphere(p+(cos(iTime)*2.2)+vec3(4.,7.,5.),1.4)+v3;
    float d5 = sdSphere(p+(sin(iTime)*2.4)+vec3(2.,3.,-3.),1.4)+v2;
    float d6 = sdSphere(p+(cos(iTime)*1.8)+vec3(9.,sin(iTime*2.)+9.,3.),1.8)+v3+v1;
    float d7 = sdSphere(p+(sin(iTime)*1.5)+vec3(5.,2.,4.),1.4)+v2;
    float d8 = sdSphere(p+(cos(iTime)*2.)+vec3(6.,0.,-2.),1.3)+v5;
    
    return minSurf(
        minSurf(
            minSurf(
                Surface(d1,vec3(3.,1.,0.)),
                Surface(d2,vec3(1.,1.,0.))
            ),
            minSurf(
                Surface(d7,vec3(0.,1.,2)),
                Surface(d8,vec3(1.,1.,2.))
            )
        ),
        minSurf(
            minSurf(
                Surface(d3,vec3(1.,1.,1.)),
                Surface(d4,vec3(0.,1.,0.))
            ),
            minSurf(
                Surface(d5,vec3(1.,0.,0.)),
                Surface(d6,vec3(0.,1.,1.))
            )
        )
    );
}

Surface march(in Ray r) {
    float t = DIST_MIN;

    for(int i=0;i<RAY_MARCH_STEPS,t<=DIST_MAX;++i) {
        Surface s = scene(r.o+t*r.d);

        if(s.t<RAY_MARCH_PRECI) {
            return Surface(t+s.t,s.c);
        }

        t = t+s.t;
    }
    
    return Surface(DIST_MAX,fond);
}

vec3 normalAt(in Surface s,in Ray r) {
    const float e = 0.01;
    vec3 p = r.o+s.t*r.d;
    float nx = scene(vec3(p.x+e,p.y,p.z)).t-scene(vec3(p.x-e,p.y,p.z)).t;
    float ny = scene(vec3(p.x,p.y+e,p.z)).t-scene(vec3(p.x,p.y-e,p.z)).t;
    float nz = scene(vec3(p.x,p.y,p.z+e)).t-scene(vec3(p.x,p.y,p.z-e)).t;

    return normalize(vec3(nx,ny,nz));
}

Ray camRay(in vec2 p) {
    // camera position
    float DP = 20.;
    float d = DP/3.;
    //vec3 ro = vec3(d*cos(iTime/2.),DP/5.0,d*sin(iTime/2.) );

    vec3 ro = vec3(10.,7.,0.);

    // target point
    //vec3 ta = vec3(0.0,DP/10.0,0.0);
    vec3 ta = vec3(0.0,0.0,0.0);

    // camera view vector
    vec3 cw = normalize(ta-ro);

    // camera up vector
    vec3 cp = vec3(0.0,1.0,0.0);

    // camera right vector
    vec3 cu = normalize(cross(cw,cp));

    // camera (normalized) up vector
    vec3 cv = normalize(cross(cu,cw));
    
    float fovDeg = 45.;
    float fovRad = (fovDeg/360.)*2.*PI;
    float zf = 1./tan(fovRad/2.);
    
    // view vector, including perspective (the more you multiply cw, the less fovy)
    vec3 rd = normalize(p.x*cu + p.y*cv*(R.y/R.x) + 2.*cw);

    return Ray(ro,rd);
}

vec3 shade(in Surface surf, in Ray ray) {
    // tous les vecteurs nécessaires au shading
    vec3 n = normalAt(surf,ray);
    vec3 l = normalize(vec3(1.,1.,0.));
    vec3 v = ray.d;
    vec3 r = reflect(l,n);
    
    // parametres du materiel
    vec3 kd = surf.c;
    vec3 ks = vec3(0.8);
    float s = 20.;
    
    // coeficients diffus et spéculaires
    float diff = max(dot(n,l),0.);
    float spec = pow(max(dot(r,v),0.),s);
    
    return kd*diff + ks*spec;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy / R.xy)*2.-1.;
    
    Ray r = camRay(uv);
    Surface s = march(r);
    vec3 c = s.c;
    
    if(iMouse.z > 0.0){
        c = fond;
    }
    
    if(s.t<DIST_MAX) {
        c = shade(s,r);
    }
    
    gl_FragColor = vec4(c,1.0); 
}